<?php

use Helpers\Menu;

$menus = new Menu();
?>
<div class="logo-header position-fixed" data-background-color="green">

    <a href="index.html" class="logo">
        <img src="../assets/img/logo.svg" alt="Logo" class="navbar-brand">
    </a>
    <button class="navbar-toggler sidenav-toggler ml-auto" type="button" data-toggle="collapse" data-target="collapse" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon">
            <i class="icon-menu"></i>
        </span>
    </button>
    <button class="topbar-toggler more"><i class="fas fa-menu"></i></button>
    <div class="nav-toggle">
        <button class="btn btn-toggle toggle-sidebar">
            <i class="icon-menu"></i>
        </button>
    </div>
</div>
<div class="sidebar sidebar-style-2" data-background-color="green">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <div class="user">
                <div class="avatar-sm float-left mr-2">
                    <?php if (!is_null($_SESSION['user_data']['uinfo_imagen']) || $_SESSION['user_data']['uinfo_imagen'] != '') : ?>
                        <img src="<?= constant('IMG_URI') ?>users/<?= $_SESSION['user_data']['uinfo_imagen']; ?>" alt="Imagen de perfil" class="avatar-img rounded-circle">
                    <?php else : ?>
                        <img src="<?= asset('assets/img/default.png'); ?>" alt="Imagen de perfil" class="avatar-img rounded-circle">
                    <?php endif; ?>
                </div>
                <div class="info">
                    <a data-toggle="collapse" href="#collapseExample" aria-expanded="true">
                        <span>
                            <?= $_SESSION['user_data']['uinfo_apellidos']; ?>
                            <span class="user-level"><?= $_SESSION['user_data']['uinfo_email']; ?></span>
                            <span class="caret"></span>
                        </span>
                    </a>
                    <div class="clearfix"></div>

                    <div class="collapse in" id="collapseExample">
                        <ul class="nav">
                            <li>
                                <a href="<?= url('miperfil') ?>">
                                    <span class="link-collapse">Perfil</span>
                                </a>
                            </li>
                            <li>
                                <a href="#settings">
                                    <span class="link-collapse">Configuracion</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php url('login/salir'); ?>">
                                    <span class="link-collapse">Salir</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <ul class="nav">
                <li class="nav-section">
                    <span class="sidebar-mini-icon">
                        <i class="fa fa-ellipsis-h"></i>
                    </span>
                    <h4 class="text-section">Opciones</h4>
                </li>
                <?php foreach ($menus->getAllowedmenus($_SESSION['user_data']['user_id']) as $menu) : ?>
                    <?php if ($menus->countHaveSubMenu($_SESSION['user_data']['user_id'], $menu['menu_id']) == 0) : ?>
                        <li class="nav-item <?= activo_menu($menu['menu_id']); ?>">
                            <a href="<?= ruta_base() . $menu['menu_id']; ?>">
                                <i class="fa fa-<?= $menu['menu_icon']; ?>"></i>
                                <p> <?= $menu['menu_descripcion']; ?></p>
                            </a>
                        </li>
                    <?php else : ?>
                        <li class="nav-item <?= activo_menu($menu['menu_id']); ?>">
                            <a data-toggle="collapse" href="#<?= $menu['menu_id']; ?>">
                                <i class="fa fa-<?= $menu['menu_icon']; ?>"></i>
                                <p><?= $menu['menu_descripcion']; ?></p>
                                <span class="caret"></span>
                            </a>
                            <div class="collapse" id="<?= $menu['menu_id']; ?>">
                                <ul class="nav nav-collapse">
                                    <?php foreach ($menus->getAllowedSubmenus($_SESSION['user_data']['user_id'], $menu['menu_id']) as $s_menu) : ?>
                                        <li class="<?= activo_submenu($s_menu['menu_id']); ?>">
                                            <a href="<?= ruta_base() . $menu['menu_id'] . '/' . $s_menu['menu_id']; ?>">
                                                <span class="sub-item"><?= $s_menu['menu_descripcion']; ?></span>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</div>