<?php

namespace Helpers;

final class Http
{
    public static function notFound()
    {
        self::get_page(404);
        exit;
    }

    private static function get_page($num)
    {
        return require "public/errores/$num.php";
    }

    public static function exit_by_forbiden()
    {
        header('HTTP/1.1 403 Forbidden');
        self::get_page(403);
        exit();
    }

    public static function exit_by_ee1001()
    {
        echo file_get_contents(ruta_base() . self::get_page('EE1001'));
        exit();
    }

    public static function go($uri = '')
    {
        exit(header("Location: $uri"));
    }

    public static function json_response($data)
    {
        header('Content-Type: application/json', true);
        echo json_encode($data);
        exit;
    }
}
