<?php

declare(strict_types=1);

use Librerias\Database;

session_start();

$options = parse_ini_file('dev.ini', false);

foreach ($options as $constant => $value) {
    define($constant, $value);
}

ini_set('include_path', constant('APP_DIR'));

switch (constant('ENTORNO')) {
    case 'desarrollo':
        ini_set('display_errors', '1');
        error_reporting(E_ALL);
        break;
    case 'produccion':
        ini_set('display_errors', '0');
        error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT & ~E_USER_NOTICE & ~E_USER_DEPRECATED);
        break;
    default:
        ini_set('display_errors', '0');
        break;
}

date_default_timezone_set("America/Caracas");

require 'librerias/Helpers/funciones.php';
require 'vendor/autoload.php';

$newDBIni = new Database();


Librerias\FrontController::inicio();
