<?php

namespace Librerias;

final class Vista
{
    public static function view(string $_vista, array $_vars = [])
    {
        $_ext = pathinfo($_vista, PATHINFO_EXTENSION);
        $_file = ('' == $_ext) ? $_vista . '.php' : $_vista;
        $_separar = explode('/', $_file);
        $array = [];

        foreach ($_separar as $key => $value) {
            if (1 == $key) {
                $array[] = 'vista';
            }
            $array[] = $value;
        }

        $_file = implode('/', $array);
        $_ruta = 'app/' . $_file;

        if (file_exists($_ruta)) {

            if (is_array($_vars))
                extract($_vars);

            require 'public/pages/head.php';
            require 'public/pages/sidebar.php';
            require 'public/pages/header.php';
            require $_ruta;
            require 'public/pages/footer.php';
        } else {
            echo 'No se puede cargar el archivo solicitado: ' . $_file;
        }
    }

    public static function viewAJAX(string $_vista, array $_vars = [])
    {
        $_ext = pathinfo($_vista, PATHINFO_EXTENSION);
        $_file = ('' == $_ext) ? $_vista . '.php' : $_vista;
        $_separar = explode('/', $_file);
        $array = [];

        foreach ($_separar as $key => $value) {
            if (1 == $key) {
                $array[] = 'vista';
            }
            $array[] = $value;
        }

        $_file = implode('/', $array);
        $_ruta = 'app/' . $_file;

        if (file_exists($_ruta)) {

            if (is_array($_vars))
                extract($_vars);

            include($_ruta);
            return;
        } else {
            echo 'No se puede cargar el archivo solicitado: ' . $_file;
        }
    }

    public static function viewPDF(string $_vista, array $_vars = [])
    {
        $_ext = pathinfo($_vista, PATHINFO_EXTENSION);
        $_file = ('' == $_ext) ? $_vista . '.php' : $_vista;
        $_separar = explode('/', $_file);
        $array = [];

        foreach ($_separar as $key => $value) {
            if (1 == $key) {
                $array[] = 'vista';
            }
            $array[] = $value;
        }

        $_file = implode('/', $array);
        $_ruta = 'app/' . $_file;

        if (file_exists($_ruta)) {

            if (is_array($_vars))
                extract($_vars);

            ob_start();
            include($_ruta);
            $output = ob_get_contents();
            @ob_end_clean();
            return $output;
        } else {
            echo 'No se puede cargar el archivo solicitado: ' . $_file;
        }
    }
}
