<?php

namespace Librerias;

use App\Modelos\UserModel;
use Helpers\Seguridad;

final class SessionManager
{
    public static function verificarSession()
    {
        if (!isset($_SESSION['logueado']) || !isset($_SESSION['user_data'])) {
            return self::redirecionarlogin();
        }
    }

    public static function verificarSessionAjax()
    {
        if (!isset($_SESSION['logueado']) || !isset($_SESSION['user_data'])) {
            session_unset();
            session_destroy();
            header('HTTP/1.0 401 Unauthorized');
            header('Content-Type: application/json', true);
            echo json_encode('exit');
            exit;
        }
    }

    public static function redirecionarlogin()
    {
        session_unset();
        session_destroy();
        header('Location: ' . ruta_base() . 'login');
        exit();
    }

    public static function procesarLogin($user, $pass)
    {
        if (!empty($user) && !empty($pass)) {
            return self::verificarUserdatos($user, $pass);
        }

        return redireccionar()->mensaje([
            'tipo'    => 'warning',
            'mensaje' => 'Por favor verifique que los datos sean enviado',
        ])->atras();
    }

    public static function verificarUserdatos($user, $pass)
    {
        $empleado_model = new UserModel();

        $usuario        = $empleado_model->getUserId($user);

        if (!isset($usuario['user_id'])) {
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Usuario no encontrado',
            ])->atras();
        }

        if ($usuario['user_estatus'] == 3) {
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Usuario Inactivo',
            ])->atras();
        }

        $usuario_personales = $empleado_model->getUserPerData($usuario['user_infoid']);

        $usuario_datos      = [
            'user_id'               => $usuario['user_id'],
            'uinfo_id'             => $usuario_personales['uinfo_id'],
            'emp_username'         => $usuario['user_username'],
            'uinfo_nombres'        => $usuario_personales['uinfo_nombres'],
            'uinfo_apellidos'      => $usuario_personales['uinfo_apellidos'],
            'uinfo_email'          => $usuario_personales['uinfo_email'],
            'uinfo_telefono_movil' => $usuario_personales['uinfo_telefono'],
            'uinfo_direccion_1'    => $usuario_personales['uinfo_direccion'],
            'uinfo_imagen'         => $usuario_personales['uinfo_imagen'],
        ];

        if (!Seguridad::verificar($pass, $usuario['user_password'])) {
            return redireccionar()->mensaje([
                'tipo'    => 'warning',
                'mensaje' => 'Contraseña incorrecta',
            ])->atras();
        }


        return self::inicioSession($usuario_datos);
    }

    public static function inicioSession($usuario_datos)
    {

        $_SESSION['logueado']  = '1';
        $_SESSION['user_data'] = $usuario_datos;
        header('Location: ' . ruta_base());
        exit();
    }

    public static function destruirSession()
    {
        return self::redirecionarlogin();
    }
}
