<?php

namespace App\Controladores;

use Helpers\Solicitud;
use Librerias\SessionManager;
use Librerias\Vista;

final class LoginControlador
{
    public function index()
    {

         (isset($_SESSION['logueado'])) ? header('Location: ' . ruta_base()) : '/login';
        exit(Vista::viewAJAX('login/login', []));
    }

    public function acceso()
    {
            $solicitud = new Solicitud();

            $user = $solicitud->sanitize($_POST['username'], FILTER_SANITIZE_SPECIAL_CHARS);
            $pass = $solicitud->sanitize($_POST['pass'], FILTER_SANITIZE_SPECIAL_CHARS);

             return SessionManager::procesarLogin($user, $pass);
    }

    public function salir()
    {
        return SessionManager::destruirSession();
    }
}
